package ru.yandex.direct.web.entity.campaign.service

import javax.annotation.ParametersAreNonnullByDefault
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.campaign.AvailableCampaignSources
import ru.yandex.direct.core.entity.campaign.model.CampaignSource
import ru.yandex.direct.core.entity.uac.repository.DirectCampaignRepository
import ru.yandex.direct.core.entity.uac.service.IUacCampaignService

@Service
@ParametersAreNonnullByDefault
class CampaignGeneratedFlagService(
    private val uacYdbDirectCampaignRepository: DirectCampaignRepository,
    private val grutUacCampaignService: IUacCampaignService
) {
    fun isGenerated(source: CampaignSource, campaignId: Long): Boolean {
        return if (!AvailableCampaignSources.isUC(source)) {
            false
        } else {
            uacYdbDirectCampaignRepository.getDirectCampaignByDirectCampaignId(campaignId) != null
                || (grutUacCampaignService.getCampaignById(campaignId.toString()) != null)
        }
    }
}
