package ru.yandex.direct.web.entity.cashback.model;

import java.math.BigDecimal;
import java.time.LocalDate;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CashbackDetailsCsvRow {
    private Long programId;
    private String programName;
    private BigDecimal reward;
    private LocalDate date;

    public Long getProgramId() {
        return programId;
    }

    public CashbackDetailsCsvRow withProgramId(Long programId) {
        this.programId = programId;
        return this;
    }

    public String getProgramName() {
        return programName;
    }

    public CashbackDetailsCsvRow withProgramName(String programName) {
        this.programName = programName;
        return this;
    }

    public BigDecimal getReward() {
        return reward;
    }

    public CashbackDetailsCsvRow withReward(BigDecimal reward) {
        this.reward = reward;
        return this;
    }

    public LocalDate getDate() {
        return date;
    }

    public CashbackDetailsCsvRow withDate(LocalDate date) {
        this.date = date;
        return this;
    }
}
