package ru.yandex.direct.web.entity.cashback.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class CashbackDetailsRequest {
    public static final String PERIOD_FIELD = "period";
    public static final String GROUP_BY_FIELD = "groupBy";

    /**
     * Период в месяцах, за который надо получить детализацию
     */
    @JsonProperty(PERIOD_FIELD)
    private int period;

    /**
     * Поле, по которому надо сгруппировать детализацию.
     *
     * Если {@code null}, то детализация будет отдана в табличном виде, как в БД.
     */
    @JsonProperty(GROUP_BY_FIELD)
    private CashbackDetailsGroupMode groupBy;

    public int getPeriod() {
        return period;
    }

    public CashbackDetailsRequest withPeriod(int period) {
        this.period = period;
        return this;
    }

    public CashbackDetailsGroupMode getGroupBy() {
        return groupBy;
    }

    public CashbackDetailsRequest withGroupBy(CashbackDetailsGroupMode groupBy) {
        this.groupBy = groupBy;
        return this;
    }
}
