package ru.yandex.direct.web.entity.client.controller;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.client.model.ClientMeasurerAccountsResponse;
import ru.yandex.direct.web.entity.client.service.WebClientService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@RequestMapping(path = "client",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "client")
@ParametersAreNonnullByDefault
public class ClientController {

    private final WebClientService webClientService;

    @Autowired
    public ClientController(WebClientService webClientService) {
        this.webClientService = webClientService;
    }

    @ApiOperation(value = "measurerAccounts", httpMethod = "GET", nickname = "measurerAccounts")
    @ApiResponses({
            @ApiResponse(code = 200, message = "Ok", response = ClientMeasurerAccountsResponse.class),
    })
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @GetMapping("/get_measurer_accounts")
    @ResponseBody
    public WebResponse getMeasurerAccounts(
            @RequestParam(value = PARAMETER_ULOGIN) String subjectLogin,
            @RequestParam("ClientID") long clientId) {
        return webClientService.getMeasurerAccounts(clientId);
    }
}
