package ru.yandex.direct.web.entity.client.service;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.client.repository.ClientMeasurerSettingsRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.web.entity.client.model.ClientMeasurerAccountsResponse;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.web.entity.client.presentations.ClientDataConverter.toWebClientMeasurerSystem;

@Service
@ParametersAreNonnullByDefault
public class WebClientService {

    private final ClientMeasurerSettingsRepository clientMeasurerSettingsRepository;
    private final ShardHelper shardHelper;

    public WebClientService(
            ClientMeasurerSettingsRepository clientMeasurerSettingsRepository,
            ShardHelper shardHelper
    ) {
        this.clientMeasurerSettingsRepository = clientMeasurerSettingsRepository;
        this.shardHelper = shardHelper;
    }

    public ClientMeasurerAccountsResponse getMeasurerAccounts(Long clientId) {
        var shardId = shardHelper.getShardByClientId(ClientId.fromLong(clientId));
        var webClientMeasurerSystems =
                clientMeasurerSettingsRepository.getByClientId(shardId, clientId)
                        .stream()
                        .map(m -> toWebClientMeasurerSystem(m.getClientMeasurerSystem()))
                        .collect(toList());
        return new ClientMeasurerAccountsResponse().withResult(webClientMeasurerSystems);
    }
}
