package ru.yandex.direct.web.entity.communication.model;

import java.util.Set;

import ru.yandex.ads.bsyeti.libs.communications.EMessageStatus;

/**
 * Класс-контейнер для события и наборов его статусов (актуального, статусов которые были добавлены в процессе
 * операции и статусов которые были удалены в процессе операции)
 */
public class EventMessageStatusesHolder {

    private Integer eventId;

    private Set<EMessageStatus> actualStatuses;

    private Set<EMessageStatus> addedStatuses;

    private Set<EMessageStatus> removedStatuses;

    public EventMessageStatusesHolder() {
    }

    public Integer getEventId() {
        return eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public EventMessageStatusesHolder withEventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    public Set<EMessageStatus> getActualStatuses() {
        return actualStatuses;
    }

    public void setActualStatuses(Set<EMessageStatus> actualStatuses) {
        this.actualStatuses = actualStatuses;
    }

    public EventMessageStatusesHolder withActualStatuses(Set<EMessageStatus> actualStatuses) {
        this.actualStatuses = actualStatuses;
        return this;
    }

    public Set<EMessageStatus> getAddedStatuses() {
        return addedStatuses;
    }

    public void setAddedStatuses(Set<EMessageStatus> addedStatuses) {
        this.addedStatuses = addedStatuses;
    }

    public EventMessageStatusesHolder withAddedStatuses(Set<EMessageStatus> addedStatuses) {
        this.addedStatuses = addedStatuses;
        return this;
    }

    public Set<EMessageStatus> getRemovedStatuses() {
        return removedStatuses;
    }

    public void setRemovedStatuses(Set<EMessageStatus> removedStatuses) {
        this.removedStatuses = removedStatuses;
    }

    public EventMessageStatusesHolder withRemovedStatuses(Set<EMessageStatus> removedStatuses) {
        this.removedStatuses = removedStatuses;
        return this;
    }
}
