package ru.yandex.direct.web.entity.communication.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.ads.bsyeti.libs.events.TCommunicationEvent;

import static ru.yandex.direct.utils.JsonUtils.toJson;

/**
 * Запрос для отправки события в контур коммуникационной системы
 */
public class SendEventRequest {
    @JsonProperty("event")
    private JsonNode event;

    public TCommunicationEvent getParsedEvent() throws InvalidProtocolBufferException {
        TCommunicationEvent.Builder builder = TCommunicationEvent.newBuilder();
        JsonFormat.parser().merge(toJson(event), builder);
        return builder.build();
    }

    public JsonNode getEvent() {
        return this.event;
    }

    public void setEvent(JsonNode event) {
        this.event = event;
    }
}
