package ru.yandex.direct.web.entity.contentpromotion.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;

public enum ContentPromotionTypeForGetMeta {
    @JsonProperty("collection")
    COLLECTION,

    @JsonProperty("video")
    VIDEO;

    public static ContentPromotionContentType toCoreValue(
            ContentPromotionTypeForGetMeta contentPromotionTypeForGetMeta) {
        switch (contentPromotionTypeForGetMeta) {
            case COLLECTION:
                return ContentPromotionContentType.COLLECTION;
            case VIDEO:
            default:
                return ContentPromotionContentType.VIDEO;
        }
    }
}
