package ru.yandex.direct.web.entity.contentpromotion.common.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.core.entity.contentpromotion.DefaultContentPromotionMeta;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.validation.model.WebValidationResult;

public class GetContentPromotionMetaResponse<T extends DefaultContentPromotionMeta> implements WebResponse {
    private WebValidationResult validationResult;

    private T result;

    private String requestId;

    public GetContentPromotionMetaResponse(String requestId, @Nullable T result,
                           WebValidationResult validationResult) {
        setResult(result);
        this.requestId = requestId;
        this.validationResult = validationResult;
    }

    @JsonProperty("request_id")
    public String requestId() {
        return requestId;
    }

    @JsonProperty("validation_result")
    public WebValidationResult validationResult() {
        return validationResult;
    }

    @JsonGetter("result")
    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public GetContentPromotionMetaResponse withResult(T result) {
        setResult(result);
        return this;
    }

    @Override
    public boolean isSuccessful() {
        return CollectionUtils.isEmpty(validationResult.getErrors());
    }
}
