package ru.yandex.direct.web.entity.contentpromotion.common.service;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.entity.contentpromotion.common.model.GetContentPromotionMetaRequest;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.hrefHasValidLength;
import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.hrefIsNotBlank;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

/**
 * Сервис для валидации запросов получения метаданных продвигаемого видео.
 */
@Service
@ParametersAreNonnullByDefault
public class ContentPromotionValidationService {

    /**
     * Валидирует запрос на получение метаданных видео.
     *
     * @param request запрос
     * @return результат валидации
     */
    public ValidationResult<GetContentPromotionMetaRequest, Defect> validateGetMetaRequest(
            GetContentPromotionMetaRequest request) {

        ItemValidationBuilder<GetContentPromotionMetaRequest, Defect> vb = ItemValidationBuilder.of(request);

        vb.item(request.getUrl(), "url")
                .check(notNull())
                .check(hrefIsNotBlank(), When.isValid())
                .check(hrefHasValidLength(), When.isValid());

        return vb.getResult();
    }
}
