package ru.yandex.direct.web.entity.cpm.controller;

import java.util.UUID;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.inventori.model.CpmForecastResponse;
import ru.yandex.direct.web.entity.inventori.service.CampaignForecastService;
import ru.yandex.direct.web.validation.model.WebValidationResult;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@RequestMapping(value = "/cpm",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "cpm")
public class CpmController {
    private final DirectWebAuthenticationSource authenticationSource;
    private final CampaignForecastService forecastService;

    public CpmController(DirectWebAuthenticationSource authenticationSource,
                         CampaignForecastService forecastService) {
        this.authenticationSource = authenticationSource;
        this.forecastService = forecastService;
    }

    @ApiOperation(
            value = "forecast",
            httpMethod = "POST",
            nickname = "cpm-forecast"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @RequestMapping(path = "/forecast", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse forecast(
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        DirectAuthentication auth = authenticationSource.getAuthentication();
        User subjectUser = auth.getSubjectUser();
        ClientId clientId = subjectUser.getClientId();

        String requestId = UUID.randomUUID().toString().toUpperCase();

        return new CpmForecastResponse(requestId, forecastService.forecastFake(clientId), new WebValidationResult());
    }
}
