package ru.yandex.direct.web.entity.creative.controller;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.creative.model.SearchVideoCreativesResponse;
import ru.yandex.direct.web.entity.creative.service.CreativeWebService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@RequestMapping(value = "/creative", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "creative")
public class CreativeController {
    private final CreativeWebService creativeWebService;

    @Autowired
    public CreativeController(CreativeWebService creativeWebService) {
        this.creativeWebService = creativeWebService;
    }

    @ApiOperation(
            value = "searchVideoCreatives",
            httpMethod = "GET",
            nickname = "searchVideoCreatives"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = SearchVideoCreativesResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/search/video", method = RequestMethod.GET)
    @ResponseBody
    public WebResponse searchVideoCreatives(
            @RequestParam(value = "creative_ids", required = false) List<Long> creativeIds,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return creativeWebService.searchVideoCreatives(creativeIds);
    }
}
