package ru.yandex.direct.web.entity.creative.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebModerationInfo {
    @JsonProperty("html")
    private WebModerationInfoHtml html;
    @JsonProperty("images")
    private List<WebModerationInfoImage> images;
    @JsonProperty("texts")
    private List<WebModerationInfoText> texts;
    @JsonProperty("videos")
    private List<WebModerationInfoVideo> videos;
    @JsonProperty("sounds")
    private List<WebModerationInfoSound> sounds;
    @JsonProperty("aspects")
    private List<WebModerationInfoAspect> aspects;

    public WebModerationInfoHtml getHtml() {
        return html;
    }

    public WebModerationInfo withHtml(WebModerationInfoHtml html) {
        this.html = html;
        return this;
    }

    public List<WebModerationInfoImage> getImages() {
        return images;
    }

    public WebModerationInfo withImages(
            List<WebModerationInfoImage> images) {
        this.images = images;
        return this;
    }

    public List<WebModerationInfoText> getTexts() {
        return texts;
    }

    public WebModerationInfo withTexts(
            List<WebModerationInfoText> texts) {
        this.texts = texts;
        return this;
    }

    public List<WebModerationInfoVideo> getVideos() {
        return videos;
    }

    public WebModerationInfo withVideos(
            List<WebModerationInfoVideo> videos) {
        this.videos = videos;
        return this;
    }

    public List<WebModerationInfoSound> getSounds() {
        return sounds;
    }

    public WebModerationInfo withSounds(
            List<WebModerationInfoSound> sounds) {
        this.sounds = sounds;
        return this;
    }

    public List<WebModerationInfoAspect> getAspects() {
        return aspects;
    }

    public WebModerationInfo withAspects(
            List<WebModerationInfoAspect> aspects) {
        this.aspects = aspects;
        return this;
    }
}
