package ru.yandex.direct.web.entity.creative.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebVideoCreative {
    @JsonProperty("id")
    private Long id;

    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("name")
    private String name;

    @JsonProperty("type")
    private WebCreativeType type;

    @JsonProperty("live_preview_url")
    private String livePreviewUrl;

    @JsonProperty("stock_creative_id")
    private Long stockCreativeId;

    @JsonProperty("moderate_info")
    private WebModerationInfo moderationInfo;

    @JsonProperty("additional_data")
    private WebAdditionalData additionalData;

    @JsonProperty("width")
    private Long width;

    @JsonProperty("height")
    private Long height;

    @JsonProperty("duration")
    private Long duration;

    @JsonProperty("resource_url")
    private String resourceUrl;

    @JsonProperty("has_packshot")
    private Boolean hasPackshot;

    public Long getId() {
        return id;
    }

    public WebVideoCreative withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public WebVideoCreative withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getName() {
        return name;
    }

    public WebVideoCreative withName(String name) {
        this.name = name;
        return this;
    }

    public WebCreativeType getType() {
        return type;
    }

    public WebVideoCreative withType(WebCreativeType type) {
        this.type = type;
        return this;
    }

    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public WebVideoCreative withLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
        return this;
    }

    public Long getStockCreativeId() {
        return stockCreativeId;
    }

    public WebVideoCreative withStockCreativeId(Long stockCreativeId) {
        this.stockCreativeId = stockCreativeId;
        return this;
    }

    public WebModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public WebVideoCreative withModerationInfo(
            WebModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
        return this;
    }

    public WebAdditionalData getAdditionalData() {
        return additionalData;
    }

    public WebVideoCreative withAdditionalData(WebAdditionalData additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public Long getWidth() {
        return width;
    }

    public WebVideoCreative withWidth(Long width) {
        this.width = width;
        return this;
    }

    public Long getHeight() {
        return height;
    }

    public WebVideoCreative withHeight(Long height) {
        this.height = height;
        return this;
    }

    public Long getDuration() {
        return duration;
    }

    public WebVideoCreative withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public WebVideoCreative withResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        return this;
    }

    public void setHasPackshot(Boolean hasPackshot) {
        this.hasPackshot = hasPackshot;
    }

    public WebVideoCreative withHasPackshot(Boolean hasPackshot) {
        this.hasPackshot = hasPackshot;
        return this;
    }
}
