package ru.yandex.direct.web.entity.creative.presentation;

import ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds.AdminReject.CREATIVE_IS_ADMIN_REJECTED;
import static ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds.ClientIds.CREATIVE_NOT_BELONG_TO_CLIENT;
import static ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds.Gen.CREATE_ADDITION_FROM_VIDEO_FAILED;
import static ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds.Gen.UPLOAD_VIDEO_FAILED;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;

public class CreativeDefectPresentations {

    private CreativeDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> creativeDefectPresentationRegistry() {
        CreativeDefectTranslations translations = CreativeDefectTranslations.INSTANCE;
        return DefaultDefectPresentationRegistry.builder()
                .register(CREATIVE_NOT_BELONG_TO_CLIENT,
                        paramWebDefect(di -> translations.creativeNotBelongToClient(
                                new Identity(di.getDefect().params()))))

                .register(CREATIVE_IS_ADMIN_REJECTED,
                        paramWebDefect(di -> di.getDefect().params().getReason()))

                .register(UPLOAD_VIDEO_FAILED, defaultWebDefect())
                .register(CREATE_ADDITION_FROM_VIDEO_FAILED, defaultWebDefect())
                .build();
    }
}
