package ru.yandex.direct.web.entity.creative.service;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefects;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Service
public class CreativeWebValidationService {
    //todo: обсудить эту валидацию, сейчас её нет
    public static final int MAX_LIST_SIZE = 10_000;

    public ValidationResult<List<Long>, Defect> validateCreativeIds(List<Long> creativeIds) {
        return ListValidationBuilder.of(creativeIds, Defect.class)
                .check(notEmptyCollection())
                .check(maxListSize(MAX_LIST_SIZE), RetargetingDefects.maxIdsInSelection())
                .checkEach(validId())
                .getResult();
    }
}
