package ru.yandex.direct.web.entity.crypta.controller;


import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.web.annotations.AllowedOperatorRoles;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.entity.inventori.service.CryptaService;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.retargeting.CryptaGoalWeb;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.crypta.model.CryptaSegmentsResponse;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.rbac.RbacRole.AGENCY;
import static ru.yandex.direct.rbac.RbacRole.CLIENT;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_ADMIN;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_MANAGER;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.MANAGER;
import static ru.yandex.direct.rbac.RbacRole.MEDIA;
import static ru.yandex.direct.rbac.RbacRole.PLACER;
import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.rbac.RbacRole.SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.SUPPORT;
import static ru.yandex.direct.web.core.WebLocaleResolver.DETECTED_LOCALE_HEADER_NAME;

@Controller
@AllowedOperatorRoles
@AllowedSubjectRoles({SUPER, SUPERREADER, SUPPORT, PLACER, MEDIA, MANAGER, AGENCY,
        INTERNAL_AD_ADMIN, INTERNAL_AD_MANAGER, INTERNAL_AD_SUPERREADER, CLIENT})
@RequestMapping(value = "/targets/crypta",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "crypta")
public class CryptaController {
    private final CryptaService cryptaService;
    private static final Logger logger = LoggerFactory.getLogger(CryptaController.class);

    @Autowired
    public CryptaController(CryptaService cryptaService) {
        this.cryptaService = cryptaService;
    }

    @ApiOperation(
            value = "getCryptaSegments",
            httpMethod = "GET",
            nickname = "getCryptaSegments"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = CryptaSegmentsResponse.class)
            }
    )
    @DisableAutoCaptcha
    @RequestMapping(path = "/segments", method = RequestMethod.GET)
    @ResponseBody
    public CryptaSegmentsResponse getCryptaSegments(
            @ApiParam(value = "категория сегментов крипты")
            @RequestParam(value = "type", required = false) String type,
            @ApiParam(value = "строка поиска по названию сегментов")
            @RequestParam(value = "filter", required = false) String filter,
            @ApiParam(value = "язык для локализации", allowableValues = "ru,uk,en,tr")
            @RequestHeader(value = DETECTED_LOCALE_HEADER_NAME, required = false) String lang) {
        final List<CryptaGoalWeb> segments = cryptaService.getSegments().stream()
                .filter(s -> StringUtils.isEmpty(type) || type.equalsIgnoreCase(s.getType().name()))
                .filter(s -> StringUtils.isEmpty(filter) || s.getName().toLowerCase().contains(filter.toLowerCase()))
                .collect(toList());
        return new CryptaSegmentsResponse().withResult(segments);
    }

}
