package ru.yandex.direct.web.entity.deal.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class UpdatableWebDeal {
    public static final String DEAL_ID = "deal_id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";

    @JsonProperty(DEAL_ID)
    private Long dealId;

    @JsonProperty(NAME)
    private String name;

    @JsonProperty(DESCRIPTION)
    private String description;

    public Long getDealId() {
        return dealId;
    }

    public UpdatableWebDeal withDealId(Long dealId) {
        this.dealId = dealId;
        return this;
    }

    public String getName() {
        return name;
    }

    public UpdatableWebDeal withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public UpdatableWebDeal withDescription(String description) {
        this.description = description;
        return this;
    }
}
