package ru.yandex.direct.web.entity.deal.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class UpdateDeal {
    public static final String DEALS = "deals";
    public static final String ADD_LINKS = "add_links";
    public static final String REMOVE_LINKS = "remove_links";

    @JsonProperty(DEALS)
    private List<UpdatableWebDeal> updatableWebDealList;

    @JsonProperty(ADD_LINKS)
    private List<WebDealIdWithCampaign> addLinks;

    @JsonProperty(REMOVE_LINKS)
    private List<WebDealIdWithCampaign> removeLinks;

    public List<WebDealIdWithCampaign> getAddLinks() {
        return addLinks;
    }

    public void setAddLinks(List<WebDealIdWithCampaign> addLinks) {
        this.addLinks = addLinks;
    }

    public UpdateDeal withAddLinks(
            List<WebDealIdWithCampaign> addLinks) {
        this.addLinks = addLinks;
        return this;
    }

    public List<WebDealIdWithCampaign> getRemoveLinks() {
        return removeLinks;
    }

    public void setRemoveLinks(List<WebDealIdWithCampaign> removeLinks) {
        this.removeLinks = removeLinks;
    }

    public UpdateDeal withRemoveLinks(
            List<WebDealIdWithCampaign> removeLinks) {
        this.removeLinks = removeLinks;
        return this;
    }

    public List<UpdatableWebDeal> getUpdatableWebDealList() {
        return updatableWebDealList;
    }

    public UpdateDeal withUpdatableWebDealList(
            List<UpdatableWebDeal> updatableWebDealList) {
        this.updatableWebDealList = updatableWebDealList;
        return this;
    }
}
