package ru.yandex.direct.web.entity.deal.model;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class WebDeal {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CLIENT_ID = "client_id";
    public static final String STATUS = "status";
    public static final String COMPLETE_REASON = "complete_reason";
    public static final String DATE_START = "date_start";
    public static final String DATE_END = "date_end";
    public static final String DESCRIPTION = "description";
    public static final String EXPECTED_IMPRESSIONS_PER_WEEK = "expected_impressions_per_week";
    public static final String EXPECTED_MONEY_PER_WEEK = "expected_money_per_week";
    public static final String DEAL_TYPE = "deal_type";
    public static final String CONTACTS = "contacts";
    public static final String MIN_PRICE = "min_price";
    public static final String TARGETINGS_TEXT = "targetings_text";
    public static final String AGENCY_FEE_PERCENT = "agency_fee_percent";
    public static final String CURRENCY_CODE = "currency_code";
    public static final String PUBLISHER_NAME = "publisher_name";
    public static final String SPENT = "spent";
    public static final String CPM = "cpm";
    public static final String SHOWS = "shows";
    public static final String CPC = "cpc";
    public static final String CLICKS = "clicks";
    public static final String CTR = "ctr";
    public static final String NUMBER_OF_LINKED_CAMPAIGNS = "number_of_linked_campaigns";
    public static final String PLACEMENTS = "placements";

    @JsonProperty(ID)
    private Long id;

    @JsonProperty(NAME)
    private String name;

    @JsonProperty(CLIENT_ID)
    private Long clientId;

    @JsonProperty(STATUS)
    private WebDealStatus status;

    @JsonProperty(COMPLETE_REASON)
    private WebDealCompleteReason completeReason;

    @JsonProperty(DATE_START)
    private LocalDateTime dateStart;

    @JsonProperty(DATE_END)
    private LocalDateTime dateEnd;

    @JsonProperty(DESCRIPTION)
    private String description;

    @JsonProperty(EXPECTED_IMPRESSIONS_PER_WEEK)
    private Long expectedImpressionsPerWeek;

    @JsonProperty(EXPECTED_MONEY_PER_WEEK)
    private Long expectedMoneyPerWeek;

    @JsonProperty(DEAL_TYPE)
    private WebDealType dealType;

    @JsonProperty(CONTACTS)
    private String contacts;

    @JsonProperty(MIN_PRICE)
    private BigDecimal minPrice;

    @JsonProperty(TARGETINGS_TEXT)
    private String targetingsText;

    @JsonProperty(AGENCY_FEE_PERCENT)
    private BigDecimal agencyFeePercent;

    @JsonProperty(CURRENCY_CODE)
    private String currencyCode;

    @JsonProperty(PUBLISHER_NAME)
    private String publisherName;

    @JsonProperty(SPENT)
    private BigDecimal spent;

    @JsonProperty(CPM)
    private BigDecimal cpm;

    @JsonProperty(SHOWS)
    private Long shows;

    @JsonProperty(CPC)
    private BigDecimal cpc;

    @JsonProperty(CLICKS)
    private Long clicks;

    @JsonProperty(CTR)
    private BigDecimal ctr;

    @JsonProperty(NUMBER_OF_LINKED_CAMPAIGNS)
    private Integer numberOfLinkedCampaigns;

    @JsonProperty(PLACEMENTS)
    private List<WebDealPlacement> placements;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public WebDeal withId(Long id) {
        setId(id);
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebDeal withName(String name) {
        setName(name);
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public WebDeal withAgencyID(Long agencyID) {
        setClientId(agencyID);
        return this;
    }

    public WebDealStatus getStatus() {
        return status;
    }

    public void setStatus(WebDealStatus status) {
        this.status = status;
    }

    public void setCompleteReason(WebDealCompleteReason completeReason) {
        this.completeReason = completeReason;
    }

    public WebDealCompleteReason getCompleteReason() {
        return completeReason;
    }

    public WebDeal withCompleteReason(WebDealCompleteReason completeReason) {
        this.completeReason = completeReason;
        return this;
    }

    public WebDeal withStatus(WebDealStatus status) {
        setStatus(status);
        return this;
    }

    public LocalDateTime getDateStart() {
        return dateStart;
    }

    public void setDateStart(LocalDateTime dateStart) {
        this.dateStart = dateStart;
    }

    public WebDeal withDateStart(LocalDateTime dateStart) {
        setDateStart(dateStart);
        return this;
    }

    public LocalDateTime getDateEnd() {
        return dateEnd;
    }

    public void setDateEnd(LocalDateTime dateEnd) {
        this.dateEnd = dateEnd;
    }

    public WebDeal withDateEnd(LocalDateTime dateEnd) {
        setDateEnd(dateEnd);
        return this;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WebDeal withDescription(String description) {
        setDescription(description);
        return this;
    }

    public Long getExpectedImpressionsPerWeek() {
        return expectedImpressionsPerWeek;
    }

    public void setExpectedImpressionsPerWeek(Long expectedImpressionsPerWeek) {
        this.expectedImpressionsPerWeek = expectedImpressionsPerWeek;
    }

    public WebDeal withExpectedImpressionsPerWeek(Long expectedImpressionsPerWeek) {
        setExpectedImpressionsPerWeek(expectedImpressionsPerWeek);
        return this;
    }

    public Long getExpectedMoneyPerWeek() {
        return expectedMoneyPerWeek;
    }

    public void setExpectedMoneyPerWeek(Long expectedMoneyPerWeek) {
        this.expectedMoneyPerWeek = expectedMoneyPerWeek;
    }

    public WebDeal withExpectedMoneyPerWeek(Long expectedMoneyPerWeek) {
        setExpectedMoneyPerWeek(expectedMoneyPerWeek);
        return this;
    }

    public WebDealType getDealType() {
        return dealType;
    }

    public void setDealType(WebDealType dealType) {
        this.dealType = dealType;
    }

    public WebDeal withDealType(WebDealType dealType) {
        setDealType(dealType);
        return this;
    }

    public String getContacts() {
        return contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public WebDeal withContacts(String contacts) {
        setContacts(contacts);
        return this;
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public WebDeal withMinPrice(BigDecimal cpm) {
        setMinPrice(cpm);
        return this;
    }

    public String getTargetingsText() {
        return targetingsText;
    }

    public void setTargetingsText(String targetingsText) {
        this.targetingsText = targetingsText;
    }

    public WebDeal withTargetingsText(String targetingsText) {
        setTargetingsText(targetingsText);
        return this;
    }

    public BigDecimal getAgencyFeePercent() {
        return agencyFeePercent;
    }

    public void setAgencyFeePercent(BigDecimal agencyFeePercent) {
        this.agencyFeePercent = agencyFeePercent;
    }

    public WebDeal withAgencyFeePercent(BigDecimal agencyFeePercent) {
        this.agencyFeePercent = agencyFeePercent;
        return this;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public WebDeal withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public String getPublisherName() {
        return publisherName;
    }

    public void setPublisherName(String publisherName) {
        this.publisherName = publisherName;
    }

    public WebDeal withPublisherName(String publisherName) {
        this.publisherName = publisherName;
        return this;
    }

    public Long getShows() {
        return shows;
    }

    public WebDeal withShows(Long shows) {
        this.shows = shows;
        return this;
    }

    public Long getClicks() {
        return clicks;
    }

    public WebDeal withClicks(Long clicks) {
        this.clicks = clicks;
        return this;
    }

    public BigDecimal getSpent() {
        return spent;
    }

    public WebDeal withSpent(BigDecimal spent) {
        this.spent = spent;
        return this;
    }

    public BigDecimal getCpm() {
        return cpm;
    }

    public WebDeal withCpm(BigDecimal cpm) {
        this.cpm = cpm;
        return this;
    }

    public BigDecimal getCpc() {
        return cpc;
    }

    public WebDeal withCpc(BigDecimal cpc) {
        this.cpc = cpc;
        return this;
    }

    public BigDecimal getCtr() {
        return ctr;
    }

    public WebDeal withCtr(BigDecimal ctr) {
        this.ctr = ctr;
        return this;
    }

    public Integer getNumberOfLinkedCampaigns() {
        return numberOfLinkedCampaigns;
    }

    public WebDeal withNumberOfLinkedCampaigns(Integer numberOfLinkedCampaigns) {
        this.numberOfLinkedCampaigns = numberOfLinkedCampaigns;
        return this;
    }

    public List<WebDealPlacement> getPlacements() {
        return placements;
    }

    public WebDeal withPlacements(List<WebDealPlacement> placements) {
        this.placements = placements;
        return this;
    }
}
