package ru.yandex.direct.web.entity.deal.model;

import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.entity.campaign.model.CampaignForWebDealDetails;

public class WebDealDetailsCampaign {
    @JsonProperty("campaignId")
    private Long campaignId;

    @JsonProperty("campaignName")
    private String campaignName;

    @JsonProperty("clientId")
    private Long clientId;

    @JsonProperty("userName")
    private String userName;

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public WebDealDetailsCampaign withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getCampaignName() {
        return campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public WebDealDetailsCampaign withCampaignName(String campaignName) {
        this.campaignName = campaignName;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public WebDealDetailsCampaign withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public WebDealDetailsCampaign withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public static List<WebDealDetailsCampaign> toWebDealDetailsCampaign(List<CampaignForWebDealDetails> campaigns) {
        return campaigns.stream().map(
                campaign -> new WebDealDetailsCampaign()
                        .withCampaignId(campaign.getCampaignId())
                        .withCampaignName(campaign.getCampaignName())
                        .withClientId(campaign.getClientId())
                        .withUserName(campaign.getUserName())
        ).collect(Collectors.toList());
    }
}
