package ru.yandex.direct.web.entity.deal.model;

import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class WebDealPlacement {

    public static final String PAGE_ID = "pageId";
    public static final String DOMAIN = "domain";
    public static final String IMP_ID = "impId";
    public static final String FORMATS = "formats";

    @JsonProperty(PAGE_ID)
    private Long pageId;

    @JsonProperty(DOMAIN)
    private String domain;

    @JsonProperty(IMP_ID)
    private List<Long> impId;

    @JsonProperty(FORMATS)
    private Set<String> formats;

    public Long getPageId() {
        return pageId;
    }

    public WebDealPlacement withPageId(Long pageId) {
        this.pageId = pageId;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public WebDealPlacement withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public List<Long> getImpId() {
        return impId;
    }

    public WebDealPlacement withImpId(List<Long> impId) {
        this.impId = impId;
        return this;
    }

    public Set<String> getFormats() {
        return formats;
    }

    public WebDealPlacement withFormats(Set<String> formats) {
        this.formats = formats;
        return this;
    }
}
