package ru.yandex.direct.web.entity.deal.presentations;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.Currency.CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH;
import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.Currency.DEAL_CURRENCY_SHOULD_MATCH_CLIENT;
import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.DEAL_IS_NOT_ACTIVE;
import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.TRANSITION_IS_UNAVAILABLE;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;

public class DealDefectPresentations {

    private DealDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> dealDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(TRANSITION_IS_UNAVAILABLE, defaultWebDefect())
                .register(DEAL_IS_NOT_ACTIVE, defaultWebDefect())
                .register(CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH, defaultWebDefect())
                .register(DEAL_CURRENCY_SHOULD_MATCH_CLIENT, defaultWebDefect())
                .build();
    }
}
