package ru.yandex.direct.web.entity.deal.presentations;

import ru.yandex.direct.core.entity.deal.container.CampaignDeal;
import ru.yandex.direct.core.entity.deal.container.UpdateDealContainer;
import ru.yandex.direct.core.entity.deal.model.Deal;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.deal.model.UpdateDeal;
import ru.yandex.direct.web.entity.deal.model.WebDeal;
import ru.yandex.direct.web.entity.deal.model.WebDealIdWithCampaign;

public class DealPathConverters {
    public static final MappingPathNodeConverter DEAL_PATH_CONVERTER =
            MappingPathNodeConverter.builder(DealPathConverters.class.getName())
                    .replace(Deal.NAME.name(), WebDeal.NAME)
                    .replace(Deal.DESCRIPTION.name(), WebDeal.DESCRIPTION)
                    .build();

    public static final MappingPathNodeConverter LINK_CAMPAIGNS_PATH_CONVERTER =
            MappingPathNodeConverter.builder(DealPathConverters.class.getName())
                    .replace(UpdateDealContainer.ADDED.name(), UpdateDeal.ADD_LINKS)
                    .replace(UpdateDealContainer.REMOVED.name(), UpdateDeal.REMOVE_LINKS)
                    .build();

    public static final MappingPathNodeConverter CAMPAIGN_DEAL_PATH_CONVERTER =
            MappingPathNodeConverter.builder(DealPathConverters.class.getName())
                    .replace(CampaignDeal.DEAL_ID.name(), WebDealIdWithCampaign.DEAL_ID)
                    .replace(CampaignDeal.CAMPAIGN_ID.name(), WebDealIdWithCampaign.CAMPAIGN_ID)
                    .build();
}
