package ru.yandex.direct.web.entity.deal.service;

import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.entity.deal.model.UpdatableWebDeal;
import ru.yandex.direct.web.entity.deal.model.UpdateDeal;
import ru.yandex.direct.web.entity.deal.model.WebDealIdWithCampaign;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Service
public class DealWebValidationService {

    public ValidationResult<UpdateDeal, Defect> validateLinkCampaigns(UpdateDeal request) {
        ItemValidationBuilder<UpdateDeal, Defect> v = ItemValidationBuilder.of(request);
        v.check(notNull());
        v.list(request.getAddLinks(), UpdateDeal.ADD_LINKS)
                .checkEachBy(this::dealsToCampaignsValidator, When.isValid());
        v.list(request.getRemoveLinks(), UpdateDeal.REMOVE_LINKS)
                .checkEachBy(this::dealsToCampaignsValidator, When.isValid());
        v.list(request.getUpdatableWebDealList(), UpdateDeal.DEALS)
                .checkEachBy(this::dealsToCampaignsValidator, When.isValid());
        return v.getResult();
    }


    private ValidationResult<WebDealIdWithCampaign, Defect> dealsToCampaignsValidator(
            WebDealIdWithCampaign campaignWebDeals) {
        ItemValidationBuilder<WebDealIdWithCampaign, Defect> v = ItemValidationBuilder.of(campaignWebDeals);
        v.item(campaignWebDeals.getDealId(), WebDealIdWithCampaign.DEAL_ID)
                .check(notNull())
                .check(validId());

        v.item(campaignWebDeals.getCampaignId(), WebDealIdWithCampaign.CAMPAIGN_ID)
                .check(notNull())
                .check(validId());
        return v.getResult();
    }

    private ValidationResult<UpdatableWebDeal, Defect> dealsToCampaignsValidator(
            UpdatableWebDeal updatableWebDeal) {
        ItemValidationBuilder<UpdatableWebDeal, Defect> v = ItemValidationBuilder.of(updatableWebDeal);
        v.item(updatableWebDeal.getDealId(), UpdatableWebDeal.DEAL_ID)
                .check(notNull())
                .check(validId());

        return v.getResult();
    }
}
