package ru.yandex.direct.web.entity.excel.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class ExcelFileKey {

    public static final String FILE_NAME = "fileName";
    public static final String MDS_GROUP = "mdsGroupId";

    @JsonProperty(FILE_NAME)
    private String fileName;

    @JsonProperty(MDS_GROUP)
    private String mdsGroupId;

    public static ExcelFileKey create(String filename, int mdsGroupId) {
        return new ExcelFileKey()
                .withFileName(filename)
                .withMdsGroupId(String.valueOf(mdsGroupId));
    }

    public String getFileName() {
        return fileName;
    }

    public ExcelFileKey withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getMdsGroupId() {
        return mdsGroupId;
    }

    public ExcelFileKey withMdsGroupId(String mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
        return this;
    }
}
