package ru.yandex.direct.web.entity.excel.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class UploadedImageInfo {

    public static final String FILE_NAME = "fileName";
    public static final String IMAGE_HASH = "imageHash";

    @JsonProperty(FILE_NAME)
    private String fileName;

    @JsonProperty(IMAGE_HASH)
    private String imageHash;

    public String getFileName() {
        return fileName;
    }

    public UploadedImageInfo withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getImageHash() {
        return imageHash;
    }

    public UploadedImageInfo withImageHash(String imageHash) {
        this.imageHash = imageHash;
        return this;
    }

}
