package ru.yandex.direct.web.entity.excel.model;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.web.validation.model.ValidationResponse;
import ru.yandex.direct.web.validation.model.WebValidationResult;

@ParametersAreNonnullByDefault
public class ValidationResponseWithExcelFileUrl extends ValidationResponse {

    private static final String EXCEL_FILE_URL = "excelFileUrl";

    private final String excelFileUrl;

    public ValidationResponseWithExcelFileUrl(WebValidationResult webValidationResult, String excelFileUrl) {
        super(webValidationResult);
        this.excelFileUrl = excelFileUrl;
    }

    // фронту нужно чтобы поля были внутри result
    @JsonGetter("result")
    public Map<String, String> getResult() {
        return Map.of(EXCEL_FILE_URL, excelFileUrl);
    }

}
