package ru.yandex.direct.web.entity.excel.model.internalad;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;

@ParametersAreNonnullByDefault
public class AdGroupInfo {

    private String id;
    private String name;
    private String level;
    private LocalDateTime startTime;
    private LocalDateTime finishTime;
    private Integer rf;
    private Integer rfReset;
    private Integer maxClicksCount;
    private Integer maxClicksPeriod;
    private Integer maxStopsCount;
    private Integer maxStopsPeriod;
    private List<Long> geoIncluded;
    private List<Long> geoExcluded;
    private List<AdGroupAdditionalTargetingInfo> additionalTargetings;
    private RetargetingCondition retargetingCondition;

    @Nullable
    public String getId() {
        return id;
    }

    public AdGroupInfo withId(@Nullable String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public AdGroupInfo withName(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getLevel() {
        return level;
    }

    public AdGroupInfo withLevel(@Nullable String level) {
        this.level = level;
        return this;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public AdGroupInfo withStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public LocalDateTime getFinishTime() {
        return finishTime;
    }

    public AdGroupInfo withFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    public Integer getRf() {
        return rf;
    }

    public AdGroupInfo withRf(Integer rf) {
        this.rf = rf;
        return this;
    }

    public Integer getRfReset() {
        return rfReset;
    }

    public AdGroupInfo withRfReset(Integer rfReset) {
        this.rfReset = rfReset;
        return this;
    }

    public Integer getMaxClicksCount() {
        return maxClicksCount;
    }

    public AdGroupInfo withMaxClicksCount(Integer maxClicksCount) {
        this.maxClicksCount = maxClicksCount;
        return this;
    }

    public Integer getMaxClicksPeriod() {
        return maxClicksPeriod;
    }

    public AdGroupInfo withMaxClicksPeriod(Integer maxClicksPeriod) {
        this.maxClicksPeriod = maxClicksPeriod;
        return this;
    }

    public Integer getMaxStopsCount() {
        return maxStopsCount;
    }

    public AdGroupInfo withMaxStopsCount(Integer maxStopsCount) {
        this.maxStopsCount = maxStopsCount;
        return this;
    }

    public Integer getMaxStopsPeriod() {
        return maxStopsPeriod;
    }

    public AdGroupInfo withMaxStopsPeriod(Integer maxStopsPeriod) {
        this.maxStopsPeriod = maxStopsPeriod;
        return this;
    }

    public List<Long> getGeoIncluded() {
        return geoIncluded;
    }

    public AdGroupInfo withGeoIncluded(List<Long> geoIncluded) {
        this.geoIncluded = geoIncluded;
        return this;
    }

    public List<Long> getGeoExcluded() {
        return geoExcluded;
    }

    public AdGroupInfo withGeoExcluded(List<Long> geoExcluded) {
        this.geoExcluded = geoExcluded;
        return this;
    }

    public List<AdGroupAdditionalTargetingInfo> getAdditionalTargetings() {
        return additionalTargetings;
    }

    public AdGroupInfo withAdditionalTargetings(List<AdGroupAdditionalTargetingInfo> additionalTargeting) {
        this.additionalTargetings = additionalTargeting;
        return this;
    }

    public RetargetingCondition getRetargetingCondition() {
        return retargetingCondition;
    }

    public AdGroupInfo withRetargetingCondition(RetargetingCondition retargetingCondition) {
        this.retargetingCondition = retargetingCondition;
        return this;
    }
}
