package ru.yandex.direct.web.entity.excel.model.internalad;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AdInfo {

    private String adGroupId;
    private String adGroupName;
    private String id;
    private String description;
    private List<TemplateVariableInfo> templateVariables;
    private List<ImageInfo> images;

    @Nullable
    public String getAdGroupId() {
        return adGroupId;
    }

    public AdInfo withAdGroupId(@Nullable String adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public AdInfo withAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
        return this;
    }

    @Nullable
    public String getId() {
        return id;
    }

    public AdInfo withId(@Nullable String id) {
        this.id = id;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public AdInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<TemplateVariableInfo> getTemplateVariables() {
        return templateVariables;
    }

    public AdInfo withTemplateVariables(List<TemplateVariableInfo> templateVariables) {
        this.templateVariables = templateVariables;
        return this;
    }

    public List<ImageInfo> getImages() {
        return images;
    }

    public AdInfo withImages(List<ImageInfo> images) {
        this.images = images;
        return this;
    }
}
