package ru.yandex.direct.web.entity.excel.model.internalad;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.image.model.BannerImageFormat;

@ParametersAreNonnullByDefault
public class ImageInfo {

    private String imageHash;
    private Integer height;
    private Integer width;
    private String mdsGroupId;
    private String namespace;
    private Boolean needUpload;
    private String fileName;
    private String url;

    public static ImageInfo fromUrl(String url) {
        return new ImageInfo()
                .withNeedUpload(true)
                .withFileName("") // фронт ожидает, что поле будет не null
                .withUrl(url);
    }

    public static ImageInfo fromFileName(String fileName) {
        return new ImageInfo()
                .withNeedUpload(true)
                .withFileName(fileName);
    }

    public static ImageInfo fromBannerImage(String imageFileName, BannerImageFormat bannerImageFormat) {
        return new ImageInfo()
                .withNeedUpload(false)
                .withImageHash(bannerImageFormat.getImageHash())
                .withHeight(bannerImageFormat.getSize().getHeight())
                .withWidth(bannerImageFormat.getSize().getWidth())
                .withMdsGroupId(bannerImageFormat.getMdsGroupId().toString())
                .withNamespace(bannerImageFormat.getNamespace().name())
                .withFileName(imageFileName);
    }

    public String getImageHash() {
        return imageHash;
    }

    public ImageInfo withImageHash(String imageHash) {
        this.imageHash = imageHash;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public ImageInfo withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public ImageInfo withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public String getMdsGroupId() {
        return mdsGroupId;
    }

    public ImageInfo withMdsGroupId(String mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
        return this;
    }

    public String getNamespace() {
        return namespace;
    }

    public ImageInfo withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Boolean getNeedUpload() {
        return needUpload;
    }

    public ImageInfo withNeedUpload(Boolean needUpload) {
        this.needUpload = needUpload;
        return this;
    }

    @Nullable
    public String getFileName() {
        return fileName;
    }

    public ImageInfo withFileName(@Nullable String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Nullable
    public String getUrl() {
        return url;
    }

    public ImageInfo withUrl(@Nullable String url) {
        this.url = url;
        return this;
    }

}
