package ru.yandex.direct.web.entity.excel.model.internalad;

import java.util.Objects;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;

public class InternalAdExportRequest {

    public static final String EXPORT_MODE = "exportMode";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String AD_GROUP_IDS = "adGroupIds";
    public static final String AD_IDS = "adIds";
    public static final String HIDE_EMPTY_COLUMNS = "hideEmptyColumns";

    @JsonProperty(EXPORT_MODE)
    private InternalAdExportMode exportMode;

    @JsonProperty(CAMPAIGN_IDS)
    private Set<Long> campaignIds;

    @JsonProperty(AD_GROUP_IDS)
    private Set<Long> adGroupIds;

    @JsonProperty(AD_IDS)
    private Set<Long> adIds;

    @JsonProperty(HIDE_EMPTY_COLUMNS)
    private Boolean hideEmptyColumns = false;

    public InternalAdExportMode getExportMode() {
        return exportMode;
    }

    public InternalAdExportRequest withExportMode(InternalAdExportMode exportMode) {
        this.exportMode = exportMode;
        return this;
    }

    public Set<Long> getCampaignIds() {
        return campaignIds;
    }

    public InternalAdExportRequest withCampaignIds(Set<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    @Nullable
    public Set<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public InternalAdExportRequest withAdGroupIds(@Nullable Set<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    @Nullable
    public Set<Long> getAdIds() {
        return adIds;
    }

    public InternalAdExportRequest withAdIds(@Nullable Set<Long> adIds) {
        this.adIds = adIds;
        return this;
    }

    public Boolean getHideEmptyColumns() {
        return hideEmptyColumns;
    }

    public InternalAdExportRequest withHideEmptyColumns(Boolean hideEmptyColumns) {
        this.hideEmptyColumns = hideEmptyColumns;
        return this;
    }

    @JsonSetter(HIDE_EMPTY_COLUMNS)
    public void setHideEmptyColumns(Boolean hideEmptyColumns) {
        if (hideEmptyColumns != null) {
            this.hideEmptyColumns = hideEmptyColumns;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalAdExportRequest that = (InternalAdExportRequest) o;
        return exportMode == that.exportMode &&
                Objects.equals(campaignIds, that.campaignIds) &&
                Objects.equals(adGroupIds, that.adGroupIds) &&
                Objects.equals(adIds, that.adIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(exportMode, campaignIds, adGroupIds, adIds);
    }
}
