package ru.yandex.direct.web.entity.excel.model.internalad;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.web.entity.excel.model.ExcelFileKey;

@ParametersAreNonnullByDefault
public class InternalAdImportInfo {

    private ExcelFileKey excelFileKey;
    private String clientLogin;
    private String campaignId;
    private String campaignName;
    private Boolean campaignArchived;
    private CampaignType campaignType;
    private String placeId;
    private List<AdGroupInfo> adGroups;
    private List<AdInfo> ads;
    private Integer adsCount;

    public ExcelFileKey getExcelFileKey() {
        return excelFileKey;
    }

    public InternalAdImportInfo withExcelFileKey(ExcelFileKey excelFileKey) {
        this.excelFileKey = excelFileKey;
        return this;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public InternalAdImportInfo withClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public String getCampaignId() {
        return campaignId;
    }

    public InternalAdImportInfo withCampaignId(String campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getCampaignName() {
        return campaignName;
    }

    public InternalAdImportInfo withCampaignName(String campaignName) {
        this.campaignName = campaignName;
        return this;
    }
    public Boolean getCampaignArchived() {
        return campaignArchived;
    }

    public InternalAdImportInfo withCampaignArchived(Boolean campaignArchived) {
        this.campaignArchived = campaignArchived;
        return this;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public InternalAdImportInfo withCampaignType(CampaignType campaignType) {
        this.campaignType = campaignType;
        return this;
    }

    public String getPlaceId() {
        return placeId;
    }

    public InternalAdImportInfo withPlaceId(String placeId) {
        this.placeId = placeId;
        return this;
    }

    @Nullable
    public List<AdGroupInfo> getAdGroups() {
        return adGroups;
    }

    public InternalAdImportInfo withAdGroups(@Nullable List<AdGroupInfo> adGroups) {
        this.adGroups = adGroups;
        return this;
    }

    @Nullable
    public List<AdInfo> getAds() {
        return ads;
    }

    public InternalAdImportInfo withAds(@Nullable List<AdInfo> ads) {
        this.ads = ads;
        return this;
    }

    @Nullable
    public Integer getAdsCount() {
        return adsCount;
    }

    public InternalAdImportInfo withAdsCount(@Nullable Integer adsCount) {
        this.adsCount = adsCount;
        return this;
    }
}
