package ru.yandex.direct.web.entity.excel.model.internalad;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.entity.excel.model.ExcelFileKey;
import ru.yandex.direct.web.entity.excel.model.UploadedImageInfo;

@ParametersAreNonnullByDefault
public class InternalAdImportRequest {

    public static final String EXCEL_FILE_KEY = "excelFileKey";
    public static final String IMPORT_MODE = "importMode";
    public static final String ONLY_VALIDATION = "onlyValidation";
    public static final String ADS_IMAGES = "adsImages";

    @JsonProperty(EXCEL_FILE_KEY)
    private ExcelFileKey excelFileKey;

    @JsonProperty(IMPORT_MODE)
    private InternalAdImportMode importMode;

    @JsonProperty(ONLY_VALIDATION)
    private Boolean onlyValidation;

    @JsonProperty(ADS_IMAGES)
    private List<UploadedImageInfo> adsImages;

    public ExcelFileKey getExcelFileKey() {
        return excelFileKey;
    }

    public InternalAdImportRequest withExcelFileKey(ExcelFileKey excelFileKey) {
        this.excelFileKey = excelFileKey;
        return this;
    }

    public InternalAdImportMode getImportMode() {
        return importMode;
    }

    public InternalAdImportRequest withImportMode(InternalAdImportMode importMode) {
        this.importMode = importMode;
        return this;
    }

    public Boolean getOnlyValidation() {
        return onlyValidation;
    }

    public InternalAdImportRequest withOnlyValidation(Boolean onlyValidation) {
        this.onlyValidation = onlyValidation;
        return this;
    }

    public List<UploadedImageInfo> getAdsImages() {
        return adsImages;
    }

    public InternalAdImportRequest withAdsImages(List<UploadedImageInfo> adsImages) {
        this.adsImages = adsImages;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalAdImportRequest that = (InternalAdImportRequest) o;
        return Objects.equals(excelFileKey, that.excelFileKey) &&
                importMode == that.importMode &&
                Objects.equals(onlyValidation, that.onlyValidation) &&
                Objects.equals(adsImages, that.adsImages);
    }

    @Override
    public int hashCode() {
        return Objects.hash(excelFileKey, importMode, onlyValidation, adsImages);
    }

}
