package ru.yandex.direct.web.entity.excel.model.internalad;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class InternalAdTemplateExportRequest {

    public static final String CAMPAIGN_ID = "campaignId";
    public static final String PLACE_ID = "placeId";
    public static final String TEMPLATE_ID = "templateId";

    @JsonProperty(CAMPAIGN_ID)
    private Long campaignId;

    @JsonProperty(PLACE_ID)
    private Long placeId;

    @JsonProperty(TEMPLATE_ID)
    private Long templateId;

    public Long getCampaignId() {
        return campaignId;
    }

    public InternalAdTemplateExportRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getPlaceId() {
        return placeId;
    }

    public InternalAdTemplateExportRequest withPlaceId(Long placeId) {
        this.placeId = placeId;
        return this;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public InternalAdTemplateExportRequest withTemplateId(Long templateId) {
        this.templateId = templateId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalAdTemplateExportRequest that = (InternalAdTemplateExportRequest) o;
        return campaignId.equals(that.campaignId) &&
                placeId.equals(that.placeId) &&
                templateId.equals(that.templateId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, placeId, templateId);
    }

}
