package ru.yandex.direct.web.entity.excel.service.validation;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

@ParametersAreNonnullByDefault
public class ExcelConstraints {

    public static final String XLS_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final Set<String> SUPPORTED_CONTENT_TYPES = Set.of(XLS_CONTENT_TYPE);

    /**
     * ContentType файла поддерживается
     */
    public static Constraint<String, Defect> fileContentTypeIsSupported() {
        return fromPredicate(SUPPORTED_CONTENT_TYPES::contains, ExcelDefects.fileContentTypeIsNotSupported());
    }

    /**
     * Размер файла не превышает допустимого
     */
    public static Constraint<Long, Defect> fileSizeIsValid(long maxSize) {
        return fromPredicate(size -> size <= maxSize, ExcelDefects.fileSizeGreaterThanMax());
    }

}
