package ru.yandex.direct.web.entity.excel.service.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excel.processing.validation.ExcelDefectTranslations;
import ru.yandex.direct.excel.processing.validation.defects.ExcelDefectIds;
import ru.yandex.direct.excel.processing.validation.defects.ExcelDefectIdsWithParams;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

@ParametersAreNonnullByDefault
public class ExcelDefectPresentation {

    private ExcelDefectPresentation() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> excelDefectPresentationRegistry() {
        ExcelDefectTranslations translations = ExcelDefectTranslations.INSTANCE;
        return DefaultDefectPresentationRegistry.builder()
                .register(ExcelDefectIds.ADS_OR_AD_GROUPS_BELONG_TO_DIFFERENT_CAMPAIGNS,
                        webDefect(translations.adsOrAdGroupsBelongToDifferentCampaigns()))
                .register(ExcelDefectIds.DUPLICATE_AD_GROUP_TITLES,
                        webDefect(translations.duplicateAdGroupTitles()))
                .register(ExcelDefectIdsWithParams.INCONSISTENT_COLUMN_TITLES,
                        webDefect(translations.inconsistentColumnTitles()))
                .register(ExcelDefectIdsWithParams.AD_GROUP_ID_REQUIRED_FOR_EXISTING_AD,
                        webDefect(translations.adGroupIdRequiredForExistingAd()))
                .register(ExcelDefectIdsWithParams.AD_GROUP_BY_ID_NOT_FOUND,
                        webDefect(translations.adGroupByIdNotFound()))
                .register(ExcelDefectIdsWithParams.NEW_AD_GROUP_BY_NAME_NOT_FOUND,
                        webDefect(translations.newAdGroupByNameNotFound()))
                .register(ExcelDefectIdsWithParams.NOT_ALLOWED_ADD_NEW_AD_GROUP_WITH_NEW_AD_FOR_IMPORT_MODE,
                        webDefect(translations.notAllowedAddNewAdGroupWithNewAdForImportMode()))
                .register(ExcelDefectIds.FILE_NOT_EXIST_IN_MDS, defaultWebDefect())
                .register(WebExcelDefectIds.Gen.FILE_CONTENT_TYPE_IS_NOT_SUPPORTED, defaultWebDefect())
                .register(WebExcelDefectIds.Gen.FILE_SIZE_GREATER_THAN_MAX, defaultWebDefect())
                .register(ExcelDefectIds.MORE_THAN_ONE_GOAL_TYPE_IN_ONE_RULE, defaultWebDefect())
                .register(ExcelDefectIds.UNSUPPORTED_CRYPTA_RULE_TYPE, defaultWebDefect())
                .register(ExcelDefectIds.UNSUPPORTED_AUDIENCE_RULE_TYPE, defaultWebDefect())
                .register(ExcelDefectIds.CRYPTA_GOAL_NOT_FOUND, defaultWebDefect())
                .register(ExcelDefectIds.SOCIAL_DEMO_GOAL_NOT_FOUND, defaultWebDefect())
                .register(ExcelDefectIds.INVALID_VALUE_FOR_IMPORT,
                        paramWebDefect(di -> translations.invalidValidForImport((String) di.getValue())))
                .build();
    }

}
