package ru.yandex.direct.web.entity.excel.service.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.container.InternalAdGroupAddOrUpdateItem;
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.excel.processing.model.internalad.ExcelFetchedData;
import ru.yandex.direct.grid.processing.service.validation.presentation.SkipByDefaultMappingPathNodeConverter;
import ru.yandex.direct.validation.result.PathNodeConverter;
import ru.yandex.direct.web.entity.excel.model.ExcelFileKey;
import ru.yandex.direct.web.entity.excel.model.UploadedImageInfo;
import ru.yandex.direct.web.entity.excel.model.internalad.InternalAdExportRequest;
import ru.yandex.direct.web.entity.excel.model.internalad.InternalAdImportRequest;

import static ru.yandex.direct.validation.result.PathHelper.pathFromStrings;
import static ru.yandex.direct.web.entity.excel.controller.ExcelController.EXCEL_FILE_PARAM;

@ParametersAreNonnullByDefault
public class InternalAdPathConverters {

    private InternalAdPathConverters() {
    }

    public static final String IMPORT_EXCEL_FILE_CONTENT_TYPE_PATH = "contentType";
    public static final String IMPORT_EXCEL_FILE_SIZE_PATH = "size";
    private static final String ADDITIONAL_TARGETINGS_VALUE_PATH = "value";
    private static final String RETARGETING_CONDITION_VALUE_PATH = "value";

    public static final PathNodeConverter INTERNAL_AD_EXPORT_REQUEST_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    InternalAdExportRequest.EXPORT_MODE, InternalAdExportRequest.CAMPAIGN_IDS,
                    InternalAdExportRequest.AD_GROUP_IDS, InternalAdExportRequest.AD_IDS,
                    InternalAdExportRequest.HIDE_EMPTY_COLUMNS);

    public static final PathNodeConverter INTERNAL_AD_IMPORT_REQUEST_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    InternalAdImportRequest.EXCEL_FILE_KEY, InternalAdImportRequest.ADS_IMAGES,
                    InternalAdImportRequest.IMPORT_MODE, InternalAdImportRequest.ONLY_VALIDATION);

    public static final PathNodeConverter EXCEL_FILE_INFO_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    ExcelFileKey.FILE_NAME, ExcelFileKey.MDS_GROUP);

    public static final PathNodeConverter ADS_IMAGES_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    UploadedImageInfo.FILE_NAME, UploadedImageInfo.IMAGE_HASH);

    public static final PathNodeConverter EXCEL_FETCHED_DATA_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    ExcelFetchedData.AD_GROUPS_PATH, ExcelFetchedData.ADS_PATH);

    public static final PathNodeConverter INTERNAL_AD_GROUP_ADD_OR_UPDATE_ITEM_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    InternalAdGroupAddOrUpdateItem.AD_GROUP, InternalAdGroupAddOrUpdateItem.ADDITIONAL_TARGETINGS,
                    InternalAdGroupAddOrUpdateItem.RETARGETING_CONDITION);

    public static final PathNodeConverter INTERNAL_AD_GROUP_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    InternalAdGroup.ID, InternalAdGroup.CAMPAIGN_ID, InternalAdGroup.NAME, InternalAdGroup.LEVEL,
                    InternalAdGroup.START_TIME, InternalAdGroup.FINISH_TIME, InternalAdGroup.RF,
                    InternalAdGroup.RF_RESET, InternalAdGroup.MAX_CLICKS_COUNT, InternalAdGroup.MAX_CLICKS_PERIOD,
                    InternalAdGroup.MAX_STOPS_COUNT, InternalAdGroup.MAX_STOPS_PERIOD, InternalAdGroup.GEO);

    public static final PathNodeConverter ADDITIONAL_TARGETINGS_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(ADDITIONAL_TARGETINGS_VALUE_PATH);

    public static final PathNodeConverter RETARGETING_CONDITION_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(RETARGETING_CONDITION_VALUE_PATH);

    public static final PathNodeConverter INTERNAL_BANNER_PATH_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.skipAllFieldsConverterExcept(
                    InternalBanner.ID, InternalBanner.CAMPAIGN_ID, InternalBanner.AD_GROUP_ID,
                    InternalBanner.TEMPLATE_ID, InternalBanner.DESCRIPTION, InternalBanner.TEMPLATE_VARIABLES);

    public static String toImportExcelFilePath(String field) {
        return pathFromStrings(EXCEL_FILE_PARAM, field).toString();
    }

}
