package ru.yandex.direct.web.entity.feature.presentation;

import ru.yandex.direct.core.entity.feature.service.validation.FeatureDefectTranslations;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.feature.service.validation.FeatureDefectIds.CollectionDefectIds.FEATURE_IS_ALREADY_DISABLED_FOR_ROLE;
import static ru.yandex.direct.core.entity.feature.service.validation.FeatureDefectIds.CollectionDefectIds.FEATURE_IS_ALREADY_ENABLED_FOR_ROLE;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class FeatureDefectPresentations {

    private FeatureDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> featureDefectPresentationRegistry() {
        FeatureDefectTranslations translations = FeatureDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(FEATURE_IS_ALREADY_ENABLED_FOR_ROLE,
                        webDefect(translations.featureIsAlreadyEnabledForRole()))
                .register(FEATURE_IS_ALREADY_DISABLED_FOR_ROLE,
                        webDefect(translations.featureIsAlreadyDisabledForRole()))
                .build();
    }
}
