package ru.yandex.direct.web.entity.feature.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.feature.container.FeatureTextIdToClientIdState;
import ru.yandex.direct.core.entity.feature.container.LoginClientIdChiefLoginWithState;
import ru.yandex.direct.core.entity.feature.model.FeatureState;
import ru.yandex.direct.core.entity.feature.service.FeatureManagingService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.entity.feature.model.SetFeatureStateItem;
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService;

import static java.util.stream.Collectors.toList;

@Service
@ParametersAreNonnullByDefault
public class FeatureWebService {
    final private DirectWebAuthenticationSource directWebAuthenticationSource;
    final private FeatureManagingService featureManagingService;
    final private ValidationResultConversionService validationResultConversionService;

    @Autowired
    public FeatureWebService(DirectWebAuthenticationSource directWebAuthenticationSource,
                             FeatureManagingService featureManagingService,
                             ValidationResultConversionService validationResultConversionService) {
        this.directWebAuthenticationSource = directWebAuthenticationSource;
        this.featureManagingService = featureManagingService;
        this.validationResultConversionService = validationResultConversionService;
    }

    public WebResponse setState(List<SetFeatureStateItem> stateItems) {
        ClientId clientId = directWebAuthenticationSource.getAuthentication().getSubjectUser().getClientId();

        List<FeatureTextIdToClientIdState> states = stateItems.stream()
                .map(s -> convertStateItem(clientId, s))
                .collect(toList());

        Result<List<LoginClientIdChiefLoginWithState>> res = featureManagingService.switchFeaturesStateForClientIds(
                directWebAuthenticationSource.getAuthentication().getOperator().getUid(),
                states
        );

        if (res.isSuccessful()) {
            return new WebSuccessResponse();
        } else {
            return validationResultConversionService.buildValidationResponse(res);
        }
    }

    private FeatureTextIdToClientIdState convertStateItem(ClientId clientId, SetFeatureStateItem s) {
        return new FeatureTextIdToClientIdState()
                .withClientId(clientId)
                .withTextId(s.getFeature())
                .withState(s.isEnabled() ? FeatureState.ENABLED : FeatureState.DISABLED);
    }
}
