package ru.yandex.direct.web.entity.feed.presentations;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_APART_RESET_LOGIN_AND_PASSWORD;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_ID_IS_NOT_VALID;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_INCONSISTENT_TYPE_FOR_UPDATE;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_INVALID_FILENAME;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_INVALID_HREF;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_IS_NOT_SET;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_IS_USED_IN_CAMPAIGN_BRIEF;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_LOGIN_CANNOT_BE_EMPTY;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_LOGIN_IS_NOT_SET;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_NAME_CANNOT_BE_EMPTY;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_NOT_EXIST;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_PASSWORD_CANNOT_BE_EMPTY;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_PASSWORD_IS_NOT_SET;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_USED_IN_AD_GROUP;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_WITHOUT_URL_SOURCE_CANNOT_BE_REFRESHED;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Gen.FEED_WITH_STATUS_NEW_CANNOT_BE_REFRESHED;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.ModelId.FEED_BY_SITE_WITH_SAME_DOMAIN_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.Number.FEED_CANNOT_BE_REFRESHED_MORE_OFTEN_THAN_REFRESH_HOURS_PERIOD;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.String.FEED_BODY_FIELD_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.String.FEED_BY_SITE_CONTAINS_DUPLICATED_URL;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.String.FEED_BY_SITE_FOR_NOT_ALLOWED_URL;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.String.FEED_BY_SITE_FOR_NOT_DOMAIN_ONLY_URL;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.String.FEED_NAME_FIELD_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefectIds.String.FEED_STATUS_WRONG;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;

public class FeedDefectPresentations {

    private FeedDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> feedDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(FEED_IS_NOT_SET,
                        defaultWebDefect())
                .register(FEED_ID_IS_NOT_VALID,
                        defaultWebDefect())
                .register(FEED_USED_IN_AD_GROUP,
                        defaultWebDefect())
                .register(FEED_INVALID_HREF,
                        defaultWebDefect())
                .register(FEED_LOGIN_CANNOT_BE_EMPTY,
                        defaultWebDefect())
                .register(FEED_PASSWORD_CANNOT_BE_EMPTY,
                        defaultWebDefect())
                .register(FEED_NAME_CANNOT_BE_EMPTY,
                        defaultWebDefect())
                .register(FEED_INVALID_FILENAME,
                        defaultWebDefect())
                .register(FEED_INCONSISTENT_TYPE_FOR_UPDATE,
                        defaultWebDefect())
                .register(FEED_NOT_EXIST,
                        defaultWebDefect())
                .register(FEED_LOGIN_IS_NOT_SET,
                        defaultWebDefect())
                .register(FEED_PASSWORD_IS_NOT_SET,
                        defaultWebDefect())
                .register(FEED_APART_RESET_LOGIN_AND_PASSWORD,
                        defaultWebDefect())
                .register(FEED_STATUS_WRONG,
                        defaultWebDefect())
                .register(FEED_NAME_FIELD_IS_TOO_LONG,
                        defaultWebDefect())
                .register(FEED_BODY_FIELD_IS_TOO_LONG,
                        defaultWebDefect())
                .register(FEED_BY_SITE_CONTAINS_DUPLICATED_URL,
                        defaultWebDefect())
                .register(FEED_BY_SITE_FOR_NOT_ALLOWED_URL,
                        defaultWebDefect())
                .register(FEED_BY_SITE_FOR_NOT_DOMAIN_ONLY_URL,
                        defaultWebDefect())
                .register(FEED_BY_SITE_WITH_SAME_DOMAIN_ALREADY_EXISTS,
                        defaultWebDefect())
                .register(FEED_CANNOT_BE_REFRESHED_MORE_OFTEN_THAN_REFRESH_HOURS_PERIOD,
                        defaultWebDefect())
                .register(FEED_WITHOUT_URL_SOURCE_CANNOT_BE_REFRESHED,
                        defaultWebDefect())
                .register(FEED_WITH_STATUS_NEW_CANNOT_BE_REFRESHED,
                        defaultWebDefect())
                .register(FEED_IS_USED_IN_CAMPAIGN_BRIEF,
                        defaultWebDefect())
                .build();
    }
}
