package ru.yandex.direct.web.entity.feedback.controller;

import java.io.IOException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.captcha.CaptchaConditionKey;
import ru.yandex.direct.web.core.security.captcha.CaptchaLimits;
import ru.yandex.direct.web.core.security.captcha.CaptchaSecured;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.feedback.service.CommanderFeedbackService;

import static ru.yandex.direct.web.core.security.configuration.BlackboxWebAuthenticationConfiguration.PUBLIC_BASE_URL;

@Api(tags = "feedback")
@Controller
@RequestMapping(PUBLIC_BASE_URL + "commander-feedback")
public class CommanderFeedbackController {

    private final CommanderFeedbackService feedbackService;

    @Autowired
    public CommanderFeedbackController(CommanderFeedbackService feedbackService) {
        this.feedbackService = feedbackService;
    }

    @ApiOperation(
            value = "Send commander feedback",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class),
            @ApiResponse(code = 500, message = "Fail")
    })
    @RequestMapping(
            path = "",
            method = RequestMethod.POST,
            consumes = MediaType.MULTIPART_FORM_DATA_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE
    )
    @ResponseBody
    @DisableAutoCaptcha
    @CaptchaSecured(
            keys = CaptchaConditionKey.IP_VALUE,
            limits = @CaptchaLimits(interval = 24 * 3600, maxFreq = 30, freq = 1)
    )
    public WebResponse sendFeedback(
            @RequestParam(name = "login") String login,
            @RequestParam(name = "userEmail", required = false) String email,
            @RequestParam(name = "text") String text,
            @RequestParam(name = "screenshot", required = false) MultipartFile screenshot,
            @RequestParam(name = "data", required = false) MultipartFile logdata) throws IOException {
        return feedbackService.sendMessage(
                login,
                email,
                text,
                screenshot != null ? screenshot.getBytes() : null,
                logdata != null ? logdata.getBytes() : null
        );
    }
}
