package ru.yandex.direct.web.entity.feedback.service;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CrmTransportConfig {

    private final String logbrokerHost;
    private final String logbrokerTopic;
    private final String logbrokerTvmServiceName;
    private final String logbrokerSourceId;
    private final String mdsBucket;

    public CrmTransportConfig(
            @Value("${crm.logbroker.host}") String logbrokerHost,
            @Value("${crm.logbroker.topic}") String logbrokerTopic,
            @Value("${crm.logbroker.tvm_service_name}") String logbrokerTvmServiceName,
            @Value("${crm.logbroker.source_id}") String logbrokerSourceId,
            @Value("${crm.mds.bucket}") String mdsBucket) {
        this.logbrokerHost = logbrokerHost;
        this.logbrokerTopic = logbrokerTopic;
        this.logbrokerTvmServiceName = logbrokerTvmServiceName;
        this.logbrokerSourceId = logbrokerSourceId;
        this.mdsBucket = mdsBucket;
    }

    public String getLogbrokerHost() {
        return logbrokerHost;
    }

    public String getLogbrokerTopic() {
        return logbrokerTopic;
    }

    public String getLogbrokerTvmServiceName() {
        return logbrokerTvmServiceName;
    }

    public String getLogbrokerSourceId() {
        return logbrokerSourceId;
    }

    public String getMdsBucket() {
        return mdsBucket;
    }
}
