package ru.yandex.direct.web.entity.freelancer.controller;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.entity.freelancer.model.FreelancerAvatarUploadResponse;
import ru.yandex.direct.web.entity.freelancer.service.FreelancerAvatarWebService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@ParametersAreNonnullByDefault
@RequestMapping(value = "/freelancer", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "freelancer")
public class FreelancerUpdateController {

    private final DirectWebAuthenticationSource authenticationSource;
    private final FreelancerAvatarWebService freelancerAvatarWebService;

    @Autowired
    public FreelancerUpdateController(
            DirectWebAuthenticationSource authenticationSource,
            FreelancerAvatarWebService freelancerAvatarWebService) {
        this.authenticationSource = authenticationSource;
        this.freelancerAvatarWebService = freelancerAvatarWebService;
    }

    @ApiOperation(
            value = "uploadAvatar",
            httpMethod = "POST",
            nickname = "uploadAvatar"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = FreelancerAvatarUploadResponse.class)
            }
    )
    @PreAuthorizeWrite
    @PostMapping(
            path = "/upload_avatar",
            consumes = MediaType.MULTIPART_FORM_DATA_VALUE
    )
    @ResponseBody
    public WebResponse uploadAvatar(
            @RequestParam("file") MultipartFile file,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        DirectAuthentication auth = authenticationSource.getAuthentication();
        User subjectUser = auth.getSubjectUser();
        Long freelancerId = subjectUser.getClientId().asLong();
        return freelancerAvatarWebService.saveFile(freelancerId, file);
    }
}
