package ru.yandex.direct.web.entity.frontpage.model;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.web.core.model.WebResponse;

public class CpmYndxFrontpagePriceWarningsResponse implements WebResponse {
    private BigDecimal minPrice;
    private List<CpmYndxFrontpagePriceWarningsResponseItem> responseItems;

    public CpmYndxFrontpagePriceWarningsResponse(BigDecimal minPrice,
                                                 List<CpmYndxFrontpagePriceWarningsResponseItem> responseItems) {
        this.minPrice = minPrice;
        this.responseItems = responseItems;
    }

    @JsonGetter("min_price")
    @Nonnull
    public BigDecimal getMinPrice() {
        return minPrice;
    }

    @JsonGetter("response_items")
    @Nonnull
    public List<CpmYndxFrontpagePriceWarningsResponseItem> responseItems() {
        return responseItems;
    }

    @Override
    public boolean isSuccessful() {
        return responseItems.stream().anyMatch(CpmYndxFrontpagePriceWarningsResponseItem::isSuccessful);
    }
}
