package ru.yandex.direct.web.entity.frontpage.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import one.util.streamex.EntryStream;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService;
import ru.yandex.direct.web.validation.model.WebValidationResult;

import static ru.yandex.direct.validation.result.PathHelper.path;

/**
 * Параметры, использующиеся для построения CpmYndxFrontpagePriceWarningsResponse
 */
public class CpmYndxFrontpagePriceWarningsResponseBuilder {
    private final ValidationResultConversionService validationResultConversionService;
    private final PathNodeConverterProvider pathNodeConverterProvider;

    private BigDecimal commonMinPrice;
    private Map<Integer, BigDecimal> adGroupMinPricesByIndex;
    private List<ValidationResult<FrontpageWarningsGetItem, Defect>> validationResults;

    public CpmYndxFrontpagePriceWarningsResponseBuilder(
            ValidationResultConversionService validationResultConversionService,
            PathNodeConverterProvider pathNodeConverterProvider) {
        this.validationResultConversionService = validationResultConversionService;
        this.pathNodeConverterProvider = pathNodeConverterProvider;
    }

    public CpmYndxFrontpagePriceWarningsResponseBuilder withCommonMinPrice(BigDecimal commonMinPrice) {
        this.commonMinPrice = commonMinPrice;
        return this;
    }

    public CpmYndxFrontpagePriceWarningsResponseBuilder withAdGroupMinPrices(
            Map<Integer, BigDecimal> adGroupMinPricesByIndex) {
        this.adGroupMinPricesByIndex = adGroupMinPricesByIndex;
        return this;
    }

    public CpmYndxFrontpagePriceWarningsResponseBuilder withValidationResults(
            List<ValidationResult<FrontpageWarningsGetItem, Defect>> validationResults) {
        this.validationResults = validationResults;
        return this;
    }

    public CpmYndxFrontpagePriceWarningsResponse build() {
        return new CpmYndxFrontpagePriceWarningsResponse(commonMinPrice, buildFrontpageResponseItems());
    }

    private List<CpmYndxFrontpagePriceWarningsResponseItem> buildFrontpageResponseItems() {
        Function<ValidationResult<FrontpageWarningsGetItem, Defect>, WebValidationResult> webValidationResultBuilder =
                vr -> validationResultConversionService.buildWebValidationResult(vr, path(), pathNodeConverterProvider);
        Function<ValidationResult<FrontpageWarningsGetItem, Defect>, Long> adGroupIdRetriever =
                vr -> vr.getValue().getAdGroupId();
        return EntryStream.of(validationResults)
                .mapKeyValue((index, vr) -> new CpmYndxFrontpagePriceWarningsResponseItem(
                        webValidationResultBuilder.apply(vr),
                        adGroupIdRetriever.apply(vr),
                        adGroupMinPricesByIndex.get(index)))
                .toList();
    }
}
