package ru.yandex.direct.web.entity.frontpage.model;

import java.math.BigDecimal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.web.validation.model.WebValidationResult;

public class CpmYndxFrontpagePriceWarningsResponseItem {
    private WebValidationResult webValidationResult;
    private Long adGroupId;
    private BigDecimal adGroupMinPrice;

    public CpmYndxFrontpagePriceWarningsResponseItem(WebValidationResult webValidationResult, Long adGroupId,
                                                     BigDecimal adGroupMinPrice) {
        this.webValidationResult = webValidationResult;
        this.adGroupId = adGroupId;
        this.adGroupMinPrice = adGroupMinPrice;
    }

    @JsonGetter("validation_result")
    @Nonnull
    public WebValidationResult validationResult() {
        return webValidationResult;
    }

    @JsonGetter("adgroup_id")
    @Nullable
    public Long adGroupId() {
        return adGroupId;
    }

    @JsonGetter("is_campaign")
    @Nonnull
    public boolean isCampaign() {
        return adGroupId == null;
    }

    @JsonGetter("adgroup_min_price")
    @Nonnull
    public BigDecimal adGroupMinPrice() {
        return adGroupMinPrice;
    }

    public boolean isSuccessful() {
        return webValidationResult.getErrors().isEmpty();
    }
}
