package ru.yandex.direct.web.entity.frontpage.model;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

public class CpmYndxFrontpageWarningsRequest {
    @JsonProperty(value = "frontpage_warnings_get_items", required = false)
    @Nullable
    List<FrontpageWarningsGetItem> frontpageWarningsGetItems;

    @JsonProperty(value = "campaign_id", required = false)
    @Nullable
    Long campaignId;

    @JsonProperty(value = "campaign_geo", required = false)
    @Nullable
    String campaignGeo;

    @JsonProperty(value = "validate_campaign", required = true)
    @Nonnull
    Boolean validateCampaign;

    @JsonProperty(value = "get_adgroups_data", required = true)
    @Nonnull
    Boolean useDbAdGroups;

    @JsonProperty(value = "strategy_auto_price", required = false)
    @Nullable
    BigDecimal strategyAutoPrice;

    @JsonProperty(value = "allowed_frontpage_type", required = false)
    @Nullable
    String allowedFrontpageType;

    public List<FrontpageWarningsGetItem> getFrontpageWarningsGetItems() {
        return frontpageWarningsGetItems;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public String getCampaignGeo() {
        return campaignGeo;
    }

    public void setCampaignGeo(String campaignGeo) {
        this.campaignGeo = campaignGeo;
    }

    public Boolean getValidateCampaign() {
        return validateCampaign;
    }

    public Boolean getUseDbAdGroups() {
        return useDbAdGroups;
    }

    public BigDecimal getStrategyAutoPrice() {
        return strategyAutoPrice;
    }

    public String getAllowedFrontpageType() {
        return allowedFrontpageType;
    }

    public void setAllowedFrontpageType(String allowedFrontpageType) {
        this.allowedFrontpageType = allowedFrontpageType;
    }

    public CpmYndxFrontpageWarningsRequest withFrontpageWarningsGetItems(
            List<FrontpageWarningsGetItem> frontpageWarningsGetItems) {
        this.frontpageWarningsGetItems = frontpageWarningsGetItems;
        return this;
    }

    public CpmYndxFrontpageWarningsRequest withValidateCampaign(Boolean validateCampaign) {
        this.validateCampaign = validateCampaign;
        return this;
    }

    public CpmYndxFrontpageWarningsRequest withUseDbAdGroups(Boolean useDbAdGroups) {
        this.useDbAdGroups = useDbAdGroups;
        return this;
    }

    public CpmYndxFrontpageWarningsRequest withCampaignGeo(String campaignGeo) {
        this.campaignGeo = campaignGeo;
        return this;
    }

    public CpmYndxFrontpageWarningsRequest withAllowedFrontpageType(String allowedFrontpageType) {
        this.allowedFrontpageType = allowedFrontpageType;
        return this;
    }

    public CpmYndxFrontpageWarningsRequest withStrategyAutoPrice(BigDecimal strategyAutoPrice) {
        this.strategyAutoPrice = strategyAutoPrice;
        return this;
    }
}
