package ru.yandex.direct.web.entity.frontpage.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class FrontpageWarningsGetItem {
    public static class Prop {
        private Prop() {
        }

        public static final String PRICE = "price";
        public static final String GEO = "geo";
        public static final String ADGROUP_ID = "adgroup_id";
    }

    @JsonProperty(Prop.PRICE)
    BigDecimal price;

    @JsonProperty(Prop.GEO)
    String geo;

    @JsonProperty(Prop.ADGROUP_ID)
    Long adGroupId;

    @JsonCreator
    public FrontpageWarningsGetItem(@JsonProperty(Prop.PRICE) BigDecimal price,
                                    @JsonProperty(Prop.GEO) String geo,
                                    @JsonProperty(Prop.ADGROUP_ID) Long adGroupId) {
        this.price = price;
        this.geo = geo;
        this.adGroupId = adGroupId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public String getGeo() {
        return geo;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }
}
