package ru.yandex.direct.web.entity.grants.presentation;

import ru.yandex.direct.core.entity.grants.service.validation.GrantsDefectTranslations;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.grants.service.validation.GrantsDefectIds.Gen.INCONSISTENT_STATE_ALLOW_EDIT_CAMPAIGN_AND_ALLOW_IMPORT_XLS;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class GrantsDefectPresentations {

    private GrantsDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> grantsDefectPresentationRegistry() {
        GrantsDefectTranslations translations = GrantsDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(INCONSISTENT_STATE_ALLOW_EDIT_CAMPAIGN_AND_ALLOW_IMPORT_XLS,
                        webDefect(translations.inconsistentStateAllowEditCampaignAndAllowImportXls()))
                .build();
    }
}
